/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf;

import com.ibm.hwmca.base.rsf.CallHomeServersBean;
import com.ibm.hwmca.base.rsf.RsfRequestInfo;
import com.ibm.hwmca.base.rsf.RsfRequestsBean;
import com.ibm.hwmca.base.rsf.RsfRequestsConstants;
import com.ibm.hwmca.base.rsf.RsfRequestsErrorIds;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RequestQueueListener;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.rsf.RsfRequest;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;

public class RsfRequestsTasklet
extends PanelTasklet
implements RequestQueueListener,
RsfRequestsConstants,
RsfRequestsErrorIds {
    private static final String TRACEMASK_T = "XRSFTLTT";
    private static final String TRACEMASK_F = "XRSFTLTF";
    private static final String TRACEMASK_D = "XRSFTLTD";
    private static final String AUIML_PATH = "com.ibm.hwmca.base.rsf.res.RsfRequestsRes";
    private static final String AUIML_RPANELNAME = "RsfRequestsPanel";
    private static final String AUIML_SPANELNAME = "CallHomeServersPanel";
    private FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "RSFTasklet");
    private List pendingUpdatesQueue = new ArrayList();

    public void destroy() {
        Trace.trace(TRACEMASK_T, "<--> destroy()");
        RsfManager.getRsfManager().getConsoleRsf().removeQueueListener(this);
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACEMASK_T, "--> logException(" + throwable + ")");
        new FrameworkLog(this.logInfo, 1, throwable).log();
        Trace.trace(TRACEMASK_T, "<-- logException()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        block26: {
            Trace.trace(TRACEMASK_T, "--> service(" + request + ", " + response + ")");
            RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
            RsfRequest rsfRequest = null;
            String[] requestIds = null;
            try {
                if (request.isInitialRequest()) {
                    RsfRequestsBean bean = new RsfRequestsBean();
                    bean.setBeanName("RequestsPanelBean");
                    RsfRequestsTasklet rsfRequestsTasklet = this;
                    synchronized (rsfRequestsTasklet) {
                        if (rsf != null) {
                            bean.setQueues(this.extractRsfRequestInfo(rsf.getQueuedRequests(this)));
                        } else {
                            ArrayList emptyList = new ArrayList();
                            List[] noRequests = new List[]{emptyList, emptyList};
                            bean.setQueues(this.extractRsfRequestInfo(noRequests));
                        }
                    }
                    response.replace(AUIML_PATH, AUIML_RPANELNAME, bean);
                    break block26;
                }
                if (request.isDisposed() || request.isCanceled()) {
                    String source = (String)request.getSource();
                    Trace.trace(TRACEMASK_F, "source of dispose or cancel = \"" + source + "\"");
                    if (source.equals("RequestsPanelBean")) {
                        response.terminate();
                    } else if (source.equals("ServersPanelBean")) {
                        response.dispose();
                    } else {
                        response.noAction();
                    }
                    break block26;
                }
                String source = (String)request.getSource();
                Trace.trace(TRACEMASK_F, "source of request = \"" + source + "\"");
                if (source.equals("RequestsPanelBean")) {
                    String command = (String)request.getData("command");
                    Trace.trace(TRACEMASK_F, "requested command = \"" + command + "\"");
                    if (command.equals("ViewCallHomeItem")) {
                        CallHomeServersBean bean = new CallHomeServersBean();
                        bean.setBeanName("ServersPanelBean");
                        MachineId machine = FcsServer.getFcsServer().getLocalMachineId();
                        bean.setConsoleOutput(machine.getName());
                        bean.setGroupOutput(machine.getGroup());
                        if (rsf != null) {
                            bean.setCallHomeServersTable(rsf.getAvailableCallHomeServers());
                        } else {
                            bean.setCallHomeServersTable(new ArrayList());
                        }
                        response.openModalChild(AUIML_PATH, AUIML_SPANELNAME, bean);
                        break block26;
                    }
                    if (command.equals("CancelRequests")) {
                        requestIds = (String[])request.getData("requestids");
                        int i = 0;
                        while (i < requestIds.length) {
                            if (rsf != null && (rsfRequest = rsf.getRequest(requestIds[i])) != null) {
                                try {
                                    rsfRequest.cancel();
                                }
                                catch (IllegalStateException isEx) {
                                    Trace.trace(TRACEMASK_T, "RsfRequest.cancel() threw exception: " + isEx);
                                }
                            }
                            ++i;
                        }
                        response.noAction();
                        break block26;
                    }
                    response.noAction();
                    break block26;
                }
                if (source.equals("RSFTasklet")) {
                    List command = this.pendingUpdatesQueue;
                    synchronized (command) {
                        response.update("RequestsPanelBean", this.pendingUpdatesQueue);
                        this.pendingUpdatesQueue = new ArrayList();
                        break block26;
                    }
                }
                response.noAction();
            }
            catch (Exception ex) {
                Trace.trace(TRACEMASK_T, "Exception in service()!  Error logged!");
                TaskletException tex = new TaskletException(ex);
                new FrameworkLog(this.logInfo, 3, tex).log();
                throw tex;
            }
        }
        Trace.trace(TRACEMASK_T, "<-- service()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeRequestChanged(RsfRequest request) {
        Trace.trace(TRACEMASK_T, "--> activeRequestChanged(" + request + ")");
        HashMap<String, Object> map = null;
        PanelTaskletRequest taskletRequest = null;
        try {
            map = new HashMap<String, Object>(2);
            map.put("updateType", "activeRequestChanged");
            map.put("requestObject", new RsfRequestInfo(request));
            List list = this.pendingUpdatesQueue;
            synchronized (list) {
                this.pendingUpdatesQueue.add(map);
                if (this.pendingUpdatesQueue.size() == 1) {
                    taskletRequest = new PanelTaskletRequest();
                    taskletRequest.setSource("RSFTasklet");
                    this.postRequest("RequestsPanelBean", taskletRequest);
                }
            }
        }
        catch (TaskletException tex) {
            Trace.trace(TRACEMASK_T, "Exception in activeRequestChanged()!  Error logged!");
            new FrameworkLog(this.logInfo, 2, tex).log();
        }
        Trace.trace(TRACEMASK_T, "<-- activeRequestChanged()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addedToWaiting(RsfRequest request) {
        Trace.trace(TRACEMASK_T, "--> addedToWaiting(" + request + ")");
        HashMap<String, Object> map = null;
        PanelTaskletRequest taskletRequest = null;
        try {
            map = new HashMap<String, Object>(2);
            map.put("updateType", "addedToWaiting");
            map.put("requestObject", new RsfRequestInfo(request));
            List list = this.pendingUpdatesQueue;
            synchronized (list) {
                this.pendingUpdatesQueue.add(map);
                if (this.pendingUpdatesQueue.size() == 1) {
                    taskletRequest = new PanelTaskletRequest();
                    taskletRequest.setSource("RSFTasklet");
                    this.postRequest("RequestsPanelBean", taskletRequest);
                }
            }
        }
        catch (TaskletException tex) {
            Trace.trace(TRACEMASK_T, "Exception in addedToWaiting()!  Error logged!");
            new FrameworkLog(this.logInfo, 2, tex).log();
        }
        Trace.trace(TRACEMASK_T, "<-- addedToWaiting()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveFromWaitingToActive(RsfRequest request) {
        Trace.trace(TRACEMASK_T, "--> moveFromWaitingToActive(" + request + ")");
        HashMap<String, Object> map = null;
        PanelTaskletRequest taskletRequest = null;
        try {
            map = new HashMap<String, Object>(2);
            map.put("updateType", "movedFromWaitingToActive");
            map.put("requestObject", new RsfRequestInfo(request));
            List list = this.pendingUpdatesQueue;
            synchronized (list) {
                this.pendingUpdatesQueue.add(map);
                if (this.pendingUpdatesQueue.size() == 1) {
                    taskletRequest = new PanelTaskletRequest();
                    taskletRequest.setSource("RSFTasklet");
                    this.postRequest("RequestsPanelBean", taskletRequest);
                }
            }
        }
        catch (TaskletException tex) {
            Trace.trace(TRACEMASK_T, "Exception in movedFromWaitingToActive()!  Error logged!");
            new FrameworkLog(this.logInfo, 2, tex).log();
        }
        Trace.trace(TRACEMASK_T, "<-- moveFromWaitingToActive()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedFromActive(RsfRequest request) {
        Trace.trace(TRACEMASK_T, "--> removedFromActive(" + request + ")");
        HashMap<String, Object> map = null;
        PanelTaskletRequest taskletRequest = null;
        try {
            map = new HashMap<String, Object>(2);
            map.put("updateType", "removedFromActive");
            map.put("requestObject", new RsfRequestInfo(request));
            List list = this.pendingUpdatesQueue;
            synchronized (list) {
                this.pendingUpdatesQueue.add(map);
                if (this.pendingUpdatesQueue.size() == 1) {
                    taskletRequest = new PanelTaskletRequest();
                    taskletRequest.setSource("RSFTasklet");
                    this.postRequest("RequestsPanelBean", taskletRequest);
                }
            }
        }
        catch (TaskletException tex) {
            Trace.trace(TRACEMASK_T, "Exception in removedFromActive()!  Error logged!");
            new FrameworkLog(this.logInfo, 2, tex).log();
        }
        Trace.trace(TRACEMASK_T, "<-- removedFromActive()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedFromWaiting(RsfRequest request) {
        Trace.trace(TRACEMASK_T, "--> removedFromWaiting(" + request + ")");
        HashMap<String, Object> map = null;
        PanelTaskletRequest taskletRequest = null;
        try {
            map = new HashMap<String, Object>(2);
            map.put("updateType", "removedFromWaiting");
            map.put("requestObject", new RsfRequestInfo(request));
            List list = this.pendingUpdatesQueue;
            synchronized (list) {
                this.pendingUpdatesQueue.add(map);
                if (this.pendingUpdatesQueue.size() == 1) {
                    taskletRequest = new PanelTaskletRequest();
                    taskletRequest.setSource("RSFTasklet");
                    this.postRequest("RequestsPanelBean", taskletRequest);
                }
            }
        }
        catch (TaskletException tex) {
            Trace.trace(TRACEMASK_T, "Exception in removedFromWaiting()!  Error logged!");
            new FrameworkLog(this.logInfo, 2, tex).log();
        }
        Trace.trace(TRACEMASK_T, "<-- removedFromWaiting()");
    }

    private List[] extractRsfRequestInfo(List[] requests) {
        Trace.trace(TRACEMASK_T, "-> extractRsfRequestInfo(" + requests + ")");
        ArrayList<RsfRequestInfo> activeQueue = new ArrayList<RsfRequestInfo>(requests[0].size());
        ArrayList<RsfRequestInfo> waitingQueue = new ArrayList<RsfRequestInfo>(requests[1].size());
        List[] queues = new List[]{activeQueue, waitingQueue};
        ListIterator iterator = null;
        try {
            iterator = requests[0].listIterator();
            while (iterator.hasNext()) {
                activeQueue.add(new RsfRequestInfo((RsfRequest)iterator.next()));
            }
            iterator = requests[1].listIterator();
            while (iterator.hasNext()) {
                waitingQueue.add(new RsfRequestInfo((RsfRequest)iterator.next()));
            }
        }
        catch (Exception ex) {
            Trace.trace(TRACEMASK_T, "Exception in extractRsfRequestInfo()!  Error logged!");
            new FrameworkLog(this.logInfo, 1, ex).log();
        }
        Trace.trace(TRACEMASK_T, "<- extractRsfRequestInfo() (return: " + queues + ")");
        return queues;
    }
}

